<?php
/**
 * Compatibility
 *
 * @package     AutomatorWP\Multimedia_Content\Compatibility
 * @since       1.0.0
 */
// Exit if accessed directly
if( ! defined( 'ABSPATH' ) ) exit;

/**
 * Listener for multimedia interactions
 *
 * @since  1.0.0
 *
 * @return void
 */
function automatorwp_multimedia_content_ajax_listener() {

    global $wpdb;

    // Setup vars
    $user_id = get_current_user_id();
    $src = isset( $_REQUEST['src'] ) ? urldecode( $_REQUEST['src'] ) : '';
    $post_id = isset( $_REQUEST['post_id'] ) ? urldecode( $_REQUEST['post_id'] ) : 0;

    // Not source provided
    if( empty( $src ) ) {
        return;
    }

    $parsed = parse_url( $src );

    // Return if malformed URL
    if( $parsed === FALSE ) {
        return;
    }

    if( isset( $parsed['query'] ) ) {

        // Turn query parameters to array
        parse_str( $parsed['query'], $params );

        // Remove "_=%n" parameter from src (WordPress adds this parameter to determine the MediaElement index)
        if( isset( $params['_'] ) ) {
            unset( $params['_'] );
        }

        // Build again the full URL without the "_=%n" parameter
        if( empty( $params ) ) {
            // If not parameters found, then keep src URL without query parameters
            $src = explode( '?', $src )[0];
        } else {
            $src = explode( '?', $src )[0] . '?' . http_build_query( $params );
        }

    } else {
        $src = explode( '?', $src )[0];
    }

    // Look for achievements with this GUID
    $attachment = $wpdb->get_results( $wpdb->prepare( "SELECT * FROM $wpdb->posts WHERE guid = %s LIMIT 1;", $src ) );

    if( ! isset( $attachment[0] ) ) {
        return;
    }

    $attachment = $attachment[0];

    $mime_type = explode( '/', $attachment->post_mime_type )[0];

    // Return if this attachment is not a video or audio
    if( ! in_array( $mime_type, array( 'video', 'audio' ) ) ) {
        return;
    }

    $post_author = absint( $attachment->post_author );

    if( $mime_type === 'video' ) {
        // Trigger video action
        do_action( 'automatorwp_multimedia_content_watch_video', $attachment->ID, $user_id, $post_id, $post_author, $attachment );
    } else if( $mime_type === 'audio' ) {
        // Trigger audio action
        do_action( 'automatorwp_multimedia_content_listen_audio', $attachment->ID, $user_id, $post_id, $post_author, $attachment );
    }

}
add_action( 'wp_ajax_automatorwp_multimedia_content_listener', 'automatorwp_multimedia_content_ajax_listener' );
add_action( 'wp_ajax_nopriv_automatorwp_multimedia_content_listener', 'automatorwp_multimedia_content_ajax_listener' );

/**
 * AJAX Helper for selecting posts
 *
 * @since 1.0.0
 */
function automatorwp_multimedia_content_ajax_get_posts() {

    global $wpdb;

    // Pull back the search string
    $search = isset( $_REQUEST['q'] ) ? $wpdb->esc_like( $_REQUEST['q'] ) : '';

    // Post type conditional
    $post_type = ( isset( $_REQUEST['post_type'] ) && ! empty( $_REQUEST['post_type'] ) ? $_REQUEST['post_type'] :  array( 'post', 'page' ) );

    // For backward compatibility we added 'video' and 'audio' as a post type of this plugin triggers
    $where = '';

    // Replace video by attachment
    if( is_array( $post_type ) && $post_type[0] === 'video' ) {
        $post_type[0] = 'attachment';
        $where = wp_post_mime_type_where( 'video', 'p' );
    } else if( $post_type === 'video' ) {
        $post_type = 'attachment';
        $where = wp_post_mime_type_where( 'video', 'p' );
    }

    // Replace audio by attachment
    if( is_array( $post_type ) && $post_type[0] === 'audio' ) {
        $post_type[0] = 'attachment';
        $where = wp_post_mime_type_where( 'audio', 'p' );
    } else if( $post_type === 'audio' ) {
        $post_type = 'attachment';
        $where = wp_post_mime_type_where( 'audio', 'p' );
    }

    // Not is our request
    if( empty( $where ) ) {
        return;
    }

    if ( is_array( $post_type ) ) {
        $post_type = sprintf( 'AND p.post_type IN(\'%s\')', implode( "','", $post_type ) );
    } else {
        $post_type = sprintf( 'AND p.post_type = \'%s\'', $post_type );
    }

    $results = $wpdb->get_results( $wpdb->prepare(
        "SELECT p.ID, p.post_title
        FROM   $wpdb->posts AS p
        WHERE  1=1
               {$post_type}
               {$where}
               AND p.post_title LIKE %s
               AND p.post_status IN( 'publish', 'inherit' )",
        "%%{$search}%%"
    ) );

    /**
     * Ajax posts results (used on almost every post selector)
     * Note: Use $_REQUEST for all given parameters
     *
     * @since  1.0.0
     *
     * @param array $results
     *
     * @return array
     */
    $results = apply_filters( 'automatorwp_ajax_get_posts_results', $results );

    // Return our results
    wp_send_json_success( $results );
    die;

}
add_action( 'wp_ajax_automatorwp_get_posts', 'automatorwp_multimedia_content_ajax_get_posts', 5 );